using UnityEngine;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using Newtonsoft.Json;
using quicksdkiOS;

public class QKGame
{
#if UNITY_IOS
    [DllImport("__Internal")]
    private static extern void LuluSetListener(string gameObjectName);
    public static void loginKitSetListener(LoginKitListener listener)
    {
        Debug.Log("gameObject is " + listener.gameObject.name);
        if (listener == null)
        {
            Debug.LogError("set LoginKitListener error, listener is null");
            return;
        }
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            string gameObjectName = listener.gameObject.name;
            LuluSetListener(gameObjectName);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuInit();
    //init
    public static void txQKInit()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuInit();
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuLogin(bool isShowMenu);
     //Login
    public static void txQKLogin (bool isShowMenu)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuLogin(isShowMenu);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuLoginWithType(int type);
    //Silent Login with type
    public static void loginKitLoginWithType(int type)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuLoginWithType(type);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuFastStartGame();
    //Silent Login
    public static void txQKFastStartGame()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuFastStartGame();
        }
    }
    [DllImport("__Internal")]
    private static extern string luLuGetUserBindInfo();
    //Get User Bind status data
    public static Dictionary<string, int> loginkitGetUserBindInfo()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                string jsonString = luLuGetUserBindInfo();
                var dic = JsonConvert.DeserializeObject<Dictionary<string, int>>(jsonString);
                return dic;
            }
            catch (Exception ex)
            {
                // 捕获异常并记录错误消息
                Debug.Log("[QKGame] GetUserBindInfo : Fail to DeserializeObject"+ ex.Message);
                return new Dictionary<string, int>();
            }
        }
        return new Dictionary<string, int>();
    }
    [DllImport("__Internal")]
    private static extern void luLuUserCenter();
    //Enter User Center
    public static void txQKCenter()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuUserCenter();
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuLogout();
    //Logout
    public static void txQKLogout()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuLogout();
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuBindAccount();
    //Bind Account
    public static void txQKBindAccount()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuBindAccount();
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuBindAccountWithType(int type);
    //Bind Account with Type
    public static void txQKBindAccountWithType(int type)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuBindAccountWithType(type);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuUnbindAccountWithType(int type);
    //Unbind Account with Type
    public static void txQKUnbindAccountWithType(int type)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuUnbindAccountWithType(type);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuAccountDeletion();
    //Account Deletion
    public static void txQKAccountDeletion()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuAccountDeletion();
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuShowMenu(float y);
    //Show Float Menu
    public static void txQKShowMenu(float y)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuShowMenu(y);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuDismissMenu();
    //Hide Float Menu
    public static void txQKDismissMenu()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuDismissMenu();
        }
    }
    [DllImport("__Internal")]
     private static extern void luluSetRoleInfo(string serverName,string serverId,string roleId,string roleName,string roleLevel,string roleVipLevel);
    //Submit RoleInfo,参数 游戏服名 游戏服id 角色名 角色id 角色等级 角色vip等级
    public static void txQKSetRoleInfo(string serverName,string serverId,string roleId,string roleName,string roleLevel,string roleVipLevel)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luluSetRoleInfo(serverName,serverId,roleId,roleName,roleLevel,roleLevel);
        }
    }
    [DllImport("__Internal")]
    private static extern void luLuCongzi(string productId,string productName,string amount,string orderNo,string callBackUrl,string extrasParams);
    //Pay RMB,参数 苹果商品ID 商品名称 价格 游戏订单号 游戏收单服务器地址 透传参数
    public static void txQKCongzi(string productId,string productName,string amount,string orderNo,string callBackUrl,string extrasParams)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luLuCongzi(productId,productName,amount,orderNo,callBackUrl,extrasParams);
        }
    }
    [DllImport("__Internal")]
    private static extern void luluRestoreNonConsumptionProducts();
    //Restore NonConsumption Products
    public static void txQKRestoreNonConsumptionProducts()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luluRestoreNonConsumptionProducts();
        }
    }
    [DllImport("__Internal")]
    private static extern void luluFindProductInfo(string productIds);
    //Request products information
    public static void txQKFindProductInfo(List<string> goodsIds)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            string strJson = JsonConvert.SerializeObject(goodsIds);
            luluFindProductInfo(strJson);
        }
    }
    [DllImport("__Internal")]
    private static extern string LuluGetUserId();
    //Get user id
    public string loginKitGetUserId()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            return LuluGetUserId();
        }
        return string.Empty;
    }
    [DllImport("__Internal")]
    private static extern string LuluGetDeviceId();
    //Get device id
    public string loginKitGetDeviceId()
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            return LuluGetDeviceId();
        }
        return string.Empty;
    }
    [DllImport("__Internal")]
    private static extern void luluShowAppCommentWithAppID(string appid);
    //Show App Review
    public static void loginKitShowAppCommentWithAppID(string appid)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            luluShowAppCommentWithAppID(appid);
        }
    }
    [DllImport("__Internal")]
    private static extern void initAliNetworkDiagnosis(string secretKey, string deviceId, string siteId, string extension);
    //Init AliNetworkDiagnosis
    public static void DiagnosisInit(string secretKey, string deviceId = null, string siteId = null,  Dictionary<string, Object> paramDict = null)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                // 验证secretKey不为空
                if (string.IsNullOrEmpty(secretKey))
                {
                    Debug.LogError("secretKey cannot be null or empty.");
                    return;
                }
                // 如果参数字典为空，则创建一个新的空字典
                if (paramDict == null)
                {
                    paramDict = new Dictionary<string, Object>();
                }
                // 将参数字典序列化为JSON字符串
                string jsonString = JsonConvert.SerializeObject(paramDict, Formatting.Indented);
                initAliNetworkDiagnosis(secretKey, deviceId, siteId, jsonString);
            }
            catch (Exception ex)
            {
                Debug.Log("[QKGame] Fail to initAliNetworkDiagnosis"+ ex.Message);
            }
        }
    }
    [DllImport("__Internal")]
    private static extern void startHttpPingAliNetworkDiagnosis(string url, string traceId);
    //Http ping
    public static void startHttpPing(string url)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                // 验证url不为空
                if (string.IsNullOrEmpty(url))
                {
                    Debug.LogError("url cannot be null or empty.");
                    return;
                }
                startHttpPingAliNetworkDiagnosis(url, null);
            }
            catch (Exception ex)
            {
                Debug.Log("[QKGame] Fail to startHttpPingAliNetworkDiagnosis"+ ex.Message);
            }
        }
    }
    [DllImport("__Internal")]
    private static extern void startPingAliNetworkDiagnosis(string host,int timeout,int interfaceType,int prefer,string traceId,int size,int count,int timeInterval);
    //Ping
    public static void startPing(string url,int count,int timeout)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                // 验证url不为空
                if (string.IsNullOrEmpty(url))
                {
                    Debug.LogError("url cannot be null or empty.");
                    return;
                }
                startPingAliNetworkDiagnosis(url, timeout, 30, 1, null, 20, count, 200);
            }
            catch (Exception ex)
            {
                Debug.Log("[QKGame] Fail to startPingAliNetworkDiagnosis"+ ex.Message);
            }
        }
    }
    [DllImport("__Internal")]
    private static extern void startTcpPingAliNetworkDiagnosis(string host,int timeout,int interfaceType,int prefer,string traceId,int port,int count,int timeInterval);
    //Tcp Ping
    public static void startTcpPing(string url,int count,int timeout)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                // 验证url不为空
                if (string.IsNullOrEmpty(url))
                {
                    Debug.LogError("url cannot be null or empty.");
                    return;
                }
                startTcpPingAliNetworkDiagnosis(url, timeout, 30, 0, null, 443, count, 200);
            }
            catch (Exception ex)
            {
                Debug.Log("[QKGame] Fail to startTcpPingAliNetworkDiagnosis"+ ex.Message);
            }
        }
    }
    [DllImport("__Internal")]
    private static extern void startMtrPingAliNetworkDiagnosis(string host,int maxTtl,int maxPaths,int maxTimeEachIP,int timeout,int interfaceType,int prefer,string traceId);
    //Mtr Ping
    public static void startMtr(string url,int maxTtl,int maxPaths,int maxTimeEachIP,int timeout)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                // 验证url不为空
                if (string.IsNullOrEmpty(url))
                {
                    Debug.LogError("url cannot be null or empty.");
                    return;
                }
                startMtrPingAliNetworkDiagnosis(url, maxTtl, maxPaths, maxTimeEachIP, timeout, 30, 1, null);
            }
            catch (Exception ex)
            {
                Debug.Log("[QKGame] Fail to startMtrPingAliNetworkDiagnosis"+ ex.Message);
            }
        }
    }
    [DllImport("__Internal")]
    private static extern void startDnsAliNetworkDiagnosis(string host,string nameServer,string type,int timeout,int interfaceType,string traceId);
    //Dns
    public static void startDns(string url,string type,int timeout)
    {
        if (Application.platform != RuntimePlatform.OSXEditor)
        {
            try
            {
                // 验证url不为空
                if (string.IsNullOrEmpty(url))
                {
                    Debug.LogError("url cannot be null or empty.");
                    return;
                }
                startDnsAliNetworkDiagnosis(url, null, type, timeout, 30, null);
            }
            catch (Exception ex)
            {
                Debug.Log("[QKGame] Fail to startDnsAliNetworkDiagnosis"+ ex.Message);
            }
        }
    }
#endif
}
